﻿using UnityEngine;
using System.Collections;

public class menu_script : MonoBehaviour {
	
	//Objects
	public GameObject Main_Camera; // camera
	
	//Menu
	public string state = "menu"; // machine à etat : onglets
	//Textures des btns Menu
	public Texture btn_menu;
	public Texture btn_shop;
	public Texture titre_menu; 
	public Texture titre_shop; 
	private float btn_menu_posy = 0;
	private float btn_shop_posy = 0;
	
	//Levels
	public int state_level = 0;
	public GameObject levels;
	private float btn_levels_margin = Screen.height - 100;
	//Textures des boutons niveaux
	public Texture[] btn_levels_unlock;
	public Texture[] btn_levels_lock;
	//Textures du curseur
	public Texture menu_active;
	public Texture menu_active_off;
	public Texture[] arrows;
	
	//planettes
	public GameObject[] planettes;
	public Color[] planettes_colors_princ;
	public Color[] planettes_colors_sec;
	public Color[] planettes_colors_mine;
	
	//Verrous des niveaux
	public bool[] level_unlock;
	public GameObject[] plans_lock;
	
	//Conteurs de mineraux
	public int minerals_count;
	public int minerals_count_begining;
	public GUIStyle counter_style; //skin des counters
	
	//Scores des niveaux et besoin en mineraux
	public int[] score_levels;
	public GameObject[] score_levels_text;
	public int[] level_need_mineral;
	
	//Stocks d'armes
	public int[] weapons_stock;
	public int[] weapons_prices;
	public GameObject[] weapons_stock_text;
	public GameObject[] weapons_prices_text;
	public GameObject[] weapons_buy_btn;
	public Material btn_buy_on;
	public Material btn_buy_off;
	
	
	void Start(){
		getDatabase(); //copie les données de jeu existantes
		setWeaponsPrices(); // remplir les prix
		changePlanettesColors();
	}
	
	void Update(){
		test_level_unlock(); //test les verrous de niveaux
		testWeaponsStocks(); // remplir les stocks
		gui_anim(); // ecouter les animation des btns du gui
		planettesAnims(); //animer les planettes
		buyWeapons(); // ecouter les achats d'armes
		gallery( state_level ); //appelle le niveau actuel en face de la camera
	}
	
	void OnGUI(){
		
		GUI.Label (new Rect ( (Screen.width/2)-250, 180, 500, 20), "MINERALS : " + minerals_count, counter_style );
		GUI.Label (new Rect ( (Screen.width/2)-250, 220, 500, 20), "EXPERIENCE : " + minerals_count_begining, counter_style);
		
		switch (state){
			
		case "menu": // Affiche le menu principal ---------------------------------------

			if(GUI.Button(new Rect	( (Screen.width - 500)/2,Screen.height/3, 500, 300 ), "", "label")){ //launch level
				if(level_unlock[state_level - 1] == true){
					print (state_level);
					//lancer le niveau
					switch(state_level)
					{
					case 1: Application.LoadLevel("level01"); break;
					case 2: Application.LoadLevel("level02"); break;
					case 3: Application.LoadLevel("level03"); break;
					}
				}
			}
			//etat du menu
			if(GUI.Button(new Rect(30,30,50,40), btn_shop, "label" )) state = "shop";
			//titre + hauteur variable
			GUI.Label (new Rect ( (Screen.width - 900 )/2 , btn_menu_posy , 900, 150), titre_menu, "label" );
			//camera
			Main_Camera.transform.position = Vector3.Slerp ( Main_Camera.transform.position , new Vector3 ( 0, 0, -10 ), Time.deltaTime * 2.0f ); //position camera
			Quaternion rot_cam_menu = Quaternion.Euler(new Vector3(-1.5f,0,0)); //rotation camera
			Main_Camera.transform.rotation = Quaternion.Slerp(Main_Camera.transform.rotation, rot_cam_menu , Time.deltaTime * 1f ); // rotation camera
			//charge les btns levels
			btns_levels();
			//charge les fleches de deplacement
			arrows_levels();
			//curseur de selection
			cursorSelection();
			break;	
			
		case "shop": // Affiche la boutique ---------------------------------------
			//etat du menu
			if(GUI.Button(new Rect(30,30,50,40), btn_menu, "label" )) state = "menu";
			//titre + hauteur variable
			GUI.Label (new Rect ( (Screen.width - 900 )/2 , btn_shop_posy , 900, 150), titre_shop, "label" );
			//camera
			Main_Camera.transform.position = Vector3.Slerp ( Main_Camera.transform.position , new Vector3 ( 0, 10.5f , -10 ), Time.deltaTime * 2.0f );
			Quaternion rot_cam_shop = Quaternion.Euler(new Vector3(1.5f,0,0));
			Main_Camera.transform.rotation = Quaternion.Slerp(Main_Camera.transform.rotation, rot_cam_shop , Time.deltaTime * 1f );
			//anime les armes
			animationWeapons(); 
			break;
		}
	}
	
	//database ------------------------------------//
		
	void getDatabase(){ //copie les données de jeu existantes
		
		minerals_count_begining = PlayerPrefs.GetInt("minerals_count_begining");
		
		if( minerals_count_begining == 0 )firstTimePlay();
		else{
			
			minerals_count = PlayerPrefs.GetInt("minerals_count");
			
			weapons_stock[0] = PlayerPrefs.GetInt("weapons_1");
			weapons_stock[1] = PlayerPrefs.GetInt("weapons_2");
			weapons_stock[2] = PlayerPrefs.GetInt("weapons_3");
			
			score_levels[0] = PlayerPrefs.GetInt("score_1");
			score_levels[1] = PlayerPrefs.GetInt("score_2");
			score_levels[2] = PlayerPrefs.GetInt("score_3");
			score_levels[3] = PlayerPrefs.GetInt("score_4");
			score_levels[4] = PlayerPrefs.GetInt("score_5");
		}
		
	}
	
	void firstTimePlay(){ //Créer un profil vide
		
		minerals_count = 0;
		minerals_count_begining = 0;
		
		weapons_stock[0] = 0;
		weapons_stock[1] = 0;
		weapons_stock[2] = 0;
		
		score_levels[0] = 0;
		score_levels[1] = 0;
		score_levels[2] = 0;
		score_levels[3] = 0;
		score_levels[4] = 0;
		
		setDatabase();
		
	}
	
	void setDatabase(){ // sauvegarde les données sur la machine
			
		PlayerPrefs.SetInt("minerals_count", minerals_count);
		PlayerPrefs.SetInt("minerals_count_begining", minerals_count_begining);
		
		PlayerPrefs.SetInt("weapons_1", weapons_stock[0]);
		PlayerPrefs.SetInt("weapons_2", weapons_stock[1]);
		PlayerPrefs.SetInt("weapons_3", weapons_stock[2]);
		
		PlayerPrefs.SetInt("score_1", score_levels[0]);
		PlayerPrefs.SetInt("score_2", score_levels[1]);
		PlayerPrefs.SetInt("score_3", score_levels[2]);
		PlayerPrefs.SetInt("score_4", score_levels[3]);
		PlayerPrefs.SetInt("score_5", score_levels[4]);
		
	}
	
	//levels ------------------------------------//
	
	void test_level_unlock(){ //test les verrous de niveaux
		
		for(int i = 0; i < level_unlock.Length; i++){
			if(minerals_count_begining >= level_need_mineral[i]){
				level_unlock[i] = true; //supprimer le verrou
				plans_lock[i].renderer.enabled = false; //masquer le plan du verrou
				score_levels_text[i].renderer.enabled = true; //afficher le score
				score_levels_text[i].GetComponent<TextMesh>().text = "Score: " + score_levels[i]; //rempli le score
			}
			else{
				level_unlock[i] = false;//ajouter un verrou
				plans_lock[i].renderer.enabled = true;//afficher le plan du verrou
				//score_levels_text[i].renderer.enabled = false; //masquer le score
				score_levels_text[i].GetComponent<TextMesh>().text = "Requis: " + level_need_mineral[i]; //rempli l'xp requise
				if(i > 2) score_levels_text[i].GetComponent<TextMesh>().text = "Coming soon!"; //rempli l'xp requise
			}
		}
		
	}
	
	void btns_levels(){
		
		// Créer les boutons des niveaux en fonction des verrous
		for( int i=0; i < level_unlock.Length; i++){
				
			var  marginLeft =  (Screen.width - 900)/2 - 25 + (i * 225);
			
			if(level_unlock[i] == true){
				if( GUI.Button(new Rect( marginLeft, btn_levels_margin, 50, 50 ), btn_levels_unlock[i], "label"))
					state_level = i+1;
			}
			else{
				if(	GUI.Button(new Rect( marginLeft, btn_levels_margin, 50, 50 ), btn_levels_lock[i], "label")	)
					state_level = i+1;
			}	
		}
	}
	
	void arrows_levels(){
		
		//btns gauche & droite
		if( GUI.Button( new Rect ( 30 + 200, (Screen.height / 2 )- 20, 40, 40 ), arrows[0], "label" ) ){
			if ( state_level > 1 ) state_level --;
			else state_level = 5;
		}
		if( GUI.Button( new Rect ( Screen.width - 70 - 200, (Screen.height / 2) - 20, 40, 40 ), arrows[1], "label" )){
			if ( state_level < 5 )state_level ++;
			else state_level = 1;
		}
	}

	void gallery( int state_level ){ // place le niveau actuel à sa place

		//liste des angles de rotation des 5 niveaux de base
		Quaternion lvl_1 = Quaternion.Euler(new Vector3(0,0,0));
		Quaternion lvl_2 = Quaternion.Euler(new Vector3(0,72,0));
		Quaternion lvl_3 = Quaternion.Euler(new Vector3(0,144,0));
		Quaternion lvl_4 = Quaternion.Euler(new Vector3(0,216,0));
		Quaternion lvl_5 = Quaternion.Euler(new Vector3(0,288,0));
		
		float delay = Time.deltaTime * 4.0f;
	
		//faire tourner le plateau
		switch ( state_level ){
		case 1:
			levels.transform.rotation = Quaternion.Slerp(levels.transform.rotation, lvl_1, delay );
			break;
		case 2:
			levels.transform.rotation = Quaternion.Slerp(levels.transform.rotation, lvl_2, delay );
			break;
		case 3:
			levels.transform.rotation = Quaternion.Slerp(levels.transform.rotation, lvl_3, delay );
			break;
		case 4:
			levels.transform.rotation = Quaternion.Slerp(levels.transform.rotation, lvl_4, delay );
			break;
		case 5:
			levels.transform.rotation = Quaternion.Slerp(levels.transform.rotation, lvl_5, delay );
			break;
		}
	}
	
	void cursorSelection(){
		for( int i=0; i < level_unlock.Length; i++){ // affiche le cercle "actif" autour des boutons
			if(i == state_level-1) 
				if( level_unlock[i] )	GUI.Label (new Rect ((Screen.width - 900)/2 - 64 + (i * 225), Screen.height - 139 ,128,128), menu_active );
				else 					GUI.Label (new Rect ((Screen.width - 900)/2 - 64 + (i * 225), Screen.height - 139 ,128,128), menu_active_off );
		}
	}
	
	//planetes ------------------------------------//
	
	void changePlanettesColors()
	{
		for ( int i = 0; i < planettes.Length; i++ )
		{
			Color new_color_princ = planettes_colors_princ[i];
			Color new_color_sec = planettes_colors_sec[i];
			Color new_color_mine = planettes_colors_mine[i];
			
			foreach ( Transform child in planettes[i].transform ){
				if ( Random.Range ( 10, 20 ) < 15 ) child.renderer.material.color = new_color_princ;
				else child.renderer.material.color = new_color_sec; 
				if ( Random.Range ( 0, 5 ) == 0 ) child.renderer.material.color = new_color_mine;
			}
		}
	}
	
	//weapons ------------------------------------//
	
	void setWeaponsPrices(){
		for( int i = 0; i < weapons_prices_text.Length; i++ ){
			weapons_prices_text[i].GetComponent<TextMesh>().text = "Price : " + weapons_prices[i]; // remplir les prix
		}
	}
	
	void testWeaponsStocks(){
		for( int i = 0; i < weapons_stock_text.Length; i++ ){
			var stock = weapons_stock[i].ToString();
			if ( weapons_prices[i] == 0 )  stock = "unlimited";
			weapons_stock_text[i].GetComponent<TextMesh>().text = "Stock : " + stock; // remplir les prix
		}
	}
	
	void buyWeapons(){
		
		//change de texture si pas assez d'argent disponible
		for( int i=1; i < weapons_prices.Length; i++){
			if ( minerals_count >= weapons_prices[i] ) weapons_buy_btn[i].transform.renderer.material = btn_buy_on;
			else weapons_buy_btn[i].transform.renderer.material = btn_buy_off;
		}
		
		//au clique sur chacun des bouton pour acheter
		if(Input.GetMouseButtonUp(0)){
			Ray ray = Main_Camera.camera.ScreenPointToRay(Input.mousePosition);
	   		RaycastHit hit;
	    	if (Physics.Raycast(ray, out hit)){
				switch(hit.transform.name)
				{
				case "buy_w2":
					if ( minerals_count >= weapons_prices[1] )
					{
						minerals_count -= weapons_prices[1];
						weapons_stock[1] ++;
						setDatabase();
					}
					break;
				case "buy_w3":
					if ( minerals_count >= weapons_prices[2] )
					{
						minerals_count -= weapons_prices[2];
						weapons_stock[2] ++;
						setDatabase();
					}
					break;
				}
			}
		}
		
	}
	
	//animations ------------------------------------//
		
	void gui_anim(){
		
		var delay_anim = 5.0f;
		
		switch ( state ){
		case "menu":
			//menu et shop
			btn_menu_posy = Mathf.Lerp(btn_menu_posy, 0, Time.deltaTime * delay_anim );
			btn_shop_posy = Mathf.Lerp(btn_shop_posy, -150, Time.deltaTime * delay_anim );
			//levels
			btn_levels_margin = Mathf.Lerp(btn_levels_margin, Screen.height - 100, Time.deltaTime * delay_anim );
			break;
		case "shop":
			//menu et shop
			btn_menu_posy = Mathf.Lerp(btn_menu_posy, Screen.height, Time.deltaTime * delay_anim );
			btn_shop_posy = Mathf.Lerp(btn_shop_posy, 0, Time.deltaTime * delay_anim );
			//levels
			btn_levels_margin = Mathf.Lerp(btn_levels_margin, Screen.height - 10, Time.deltaTime * delay_anim );
			break;
		}
		
	}
	
	void animationWeapons(){
		var w1 = GameObject.Find ("weapon_1");
		var w2 = GameObject.Find ("weapon_2");
		var w3 = GameObject.Find ("weapon_3");
			
		w1.transform.Rotate( new Vector3 ( 2, 2, 1 ) * Time.deltaTime * 30.0f);
		w2.transform.Rotate( new Vector3 ( 2, 2, 0 ) * Time.deltaTime * 10.0f);
		w3.transform.Rotate( new Vector3 ( 2, 2, 1 ) * Time.deltaTime * 5.0f);
	}
	
	void planettesAnims(){
		planettes[state_level-1].transform.Rotate( new Vector3 ( 2, 2, 1 ) * Time.deltaTime * 3.0f);
	}
}
